using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        List<(int x, int y)> moves = new List<(int, int)>();
        for (int i = 0; i < n; i++)
        {
            var input = Console.ReadLine().Split();
            int x = int.Parse(input[0]);
            int y = int.Parse(input[1]);
            moves.Add((x, y));
        }

        long bestDist = 0;
        List<int> bestMoves = new List<int>();
        
        var distances = new List<(long dist, int index)>();
        for (int i = 0; i < n; i++)
        {
            long dist = (long)moves[i].x * moves[i].x + (long)moves[i].y * moves[i].y;
            distances.Add((dist, i + 1));
        }

        distances = distances.OrderByDescending(d => d.dist).ToList();

        long x = 0, y = 0;
        foreach (var move in distances)
        {
            x += moves[move.index - 1].x;
            y += moves[move.index - 1].y;
            bestMoves.Add(move.index);
        }

        Console.WriteLine(bestMoves.Count);
        Console.WriteLine(string.Join(" ", bestMoves));
    }
}